<?php

/**
 * local_signupvalidations external file
 *
 * @package    component
 * @category   external
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined( 'MOODLE_INTERNAL' ) || die();

global $CFG;
require_once $CFG->libdir . '/externallib.php';

class local_signupvalidations_search_records_external extends external_api {
/*
	public static function search_records_parameters() {
		return new external_function_parameters(
			array(
				'query' => new external_value( PARAM_RAW, 'Search query for pincode, school, or UDISE code', VALUE_REQUIRED ),
			)
		);
	}

	public static function search_records( $query ) {
		global $DB;

		$params = self::validate_parameters( self::search_records_parameters(), array( 'query' => $query ) );

		$query = '%' . $DB->sql_like_escape( $params['query'] ) . '%';

		// Example SQL query (adjust based on your table schema)

		$sql = 'SELECT * FROM {local_schoolinfo} WHERE schoolpincode LIKE :pincode OR schooludise LIKE :schoolname OR schoolname LIKE :udisecodeLIMIT 10';

		// Provide parameters for each placeholder
		$results = $DB->get_records_sql(
			$sql,
			array(
				'pincode'    => $query,
				'schoolname' => $query,
				'udisecode'  => $query,
			)
		);

		return $results;
	}
 */

	public static function search_records_parameters() {
		return new external_function_parameters(
			array(
				'query'      => new external_value( PARAM_RAW, 'Search query for pincode, school, or UDISE code', VALUE_REQUIRED ),
				'stateboard' => new external_value( PARAM_RAW, 'State Board filter', VALUE_REQUIRED ), // Added parameter for stateboard
			)
		);
	}

	public static function search_records( $query, $stateboard ) {
		global $DB;

		// Validate the parameters
		$params = self::validate_parameters(
			self::search_records_parameters(),
			array(
				'query'      => $query,
				'stateboard' => $stateboard,
			)
		);

		// Escape the input values for SQL LIKE queries
		$query      = '%' . $DB->sql_like_escape( $params['query'] ) . '%';
		$stateboard = '%' . $DB->sql_like_escape( $params['stateboard'] ) . '%';

		// Update the SQL query to include an AND condition for the schoolboard
		$sql = 'SELECT * FROM {local_schoolinfo}
            WHERE (schoolpincode LIKE :pincode OR schooludise LIKE :udisecode OR schoolname LIKE :schoolname)
            AND schoolboard LIKE :stateboard
            LIMIT 20';

		// Provide parameters for each placeholder in the SQL query
		$results = $DB->get_records_sql(
			$sql,
			array(
				'pincode'    => $query,
				'schoolname' => $query,
				'udisecode'  => $query,
				'stateboard' => $stateboard, // Added the stateboard parameter
			)
		);

		return $results;
	}

	public static function search_records_returns() {
		return new external_multiple_structure(
			new external_single_structure(
				array(
					'id'             => new external_value( PARAM_INT, 'Record ID' ),
					'schoolname'     => new external_value( PARAM_TEXT, 'School Name' ),
					'schoolpincode'  => new external_value( PARAM_TEXT, 'Pincode' ),
					'schooldistrict' => new external_value( PARAM_TEXT, 'School Name' ),
					'schooludise'    => new external_value( PARAM_TEXT, 'UDISE Code' ),
				)
			)
		);
	}
}


class local_signupvalidations_schools_external extends external_api {

	public static function get_schools_parameters() {
		return new external_function_parameters(
			array( 'pincode' => new external_value( PARAM_TEXT, 'Pincode' ) )
		);
	}

	public static function get_schools( $pincode ) {
		global $DB;

		// Use sql_compare_text() for comparing text fields
		$pincode_condition = $DB->sql_compare_text( 'schoolpincode' ) . ' = ' . $DB->sql_compare_text( ':pincode' );
		$params            = array( 'pincode' => $pincode );
		$schools           = $DB->get_records_select( 'local_schoolinfo', $pincode_condition, $params );

		// Prepare the results
		$result = array();
		foreach ( $schools as $school ) {
			$result[] = array(
				'id'         => $school->id,
				'schoolname' => $school->schoolname,
			);
		}
		return $result;
	}

	public static function get_schools_returns() {
		return new external_multiple_structure(
			new external_single_structure(
				array(
					'id'         => new external_value( PARAM_INT, 'School ID' ),
					'schoolname' => new external_value( PARAM_TEXT, 'School name' ),
				)
			)
		);
	}
}
class local_signupvalidations_external extends external_api {

	public static function get_districts_parameters() {
		return new external_function_parameters(
			array(
				'stateboard' => new external_value( PARAM_TEXT, 'State Board Name' ),
			)
		);
	}

	public static function get_districts( $stateboard ) {
		global $DB;

		// Parameter validation
		$params     = self::validate_parameters( self::get_districts_parameters(), array( 'stateboard' => $stateboard ) );
		$stateboard = $params['stateboard'];
		// Query the database to fetch the schools based on some condition, if any, like state board
		$districts = $DB->get_records( 'local_schoolinfo', array( 'id' => $stateboard ) );

		// Prepare the results
		$result = array();
		foreach ( $districts as $district ) {
			$result[] = array(
				'id'             => $district->id,
				'schoolname'     => $district->schoolname,
				'schoolboard'    => $district->schoolboard,
				'schooldistrict' => $district->schooldistrict,
				'schooludise'    => $district->schooludise,
				'schoolpincode'  => $district->schoolpincode,
			);
		}

		// Return the results
		return $districts;
	}

	public static function get_districts_returns() {
		return new external_multiple_structure(
			new external_single_structure(
				array(
					'id'             => new external_value( PARAM_INT, 'School ID' ),
					'schoolname'     => new external_value( PARAM_TEXT, 'School Name' ),
					'schooludise'    => new external_value( PARAM_TEXT, 'School UDISE Code' ),
					'schoolboard'    => new external_value( PARAM_TEXT, 'School Board' ),
					'schooldistrict' => new external_value( PARAM_TEXT, 'School District' ),
					'schoolpincode'  => new external_value( PARAM_TEXT, 'School Pincode' ),
				)
			)
		);
	}
}
