<?php
// This file is part of Moodle Course Rollover Plugin
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package     local_schoolinfo
 * @author      iProgrammer
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__ . '/../../config.php');

global $DB;

require_login();
$context = context_system::instance();
require_capability('local/schoolinfo:manageschoolinfos', $context);

$PAGE->set_url(new moodle_url('/local/schoolinfo/manage.php'));
$PAGE->set_context(\context_system::instance());
$PAGE->set_title(get_string('manage_schoolinfos', 'local_schoolinfo'));
$PAGE->set_heading(get_string('manage_schoolinfos', 'local_schoolinfo'));
$PAGE->requires->js_call_amd('local_schoolinfo/confirm');
$PAGE->requires->css('/local/schoolinfo/styles.css');

$schoolinfos = $DB->get_records('local_schoolinfo', null, 'id');

echo $OUTPUT->header();
$templatecontext = (object)[
    'schoolinfos' => array_values($schoolinfos),
    'editurl' => new moodle_url('/local/schoolinfo/edit.php'),
    'bulkediturl' => new moodle_url('/local/schoolinfo/bulkedit.php'),
];

echo $OUTPUT->render_from_template('local_schoolinfo/manage', $templatecontext);

echo $OUTPUT->footer();
