<?php

/**
 * local_schoolinfo external file
 *
 * @package    component
 * @category   external
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined( 'MOODLE_INTERNAL' ) || die();

use local_schoolinfo\manager;
require_once $CFG->libdir . '/externallib.php';

class local_schoolinfo_external extends external_api {
	/**
	 * Returns description of method parameters
	 *
	 * @return external_function_parameters
	 */
	public static function delete_schoolinfo_parameters() {
		return new external_function_parameters(
			array( 'schoolinfoid' => new external_value( PARAM_INT, 'id of schoolinfo' ) ),
		);
	}

	/**
	 * The function itself
	 *
	 * @return string welcome schoolinfo
	 */
	public static function delete_schoolinfo( $schoolinfoid ): string {
		$params = self::validate_parameters( self::delete_schoolinfo_parameters(), array( 'schoolinfoid' => $schoolinfoid ) );

		require_capability( 'local/schoolinfo:manageschoolinfos', context_system::instance() );

		$manager = new manager();
		return $manager->delete_schoolinfo( $schoolinfoid );
	}

	/**
	 * Returns description of method result value
	 *
	 * @return external_description
	 */
	public static function delete_schoolinfo_returns() {
		return new external_value( PARAM_BOOL, 'True if the schoolinfo was successfully deleted.' );
	}
}
