<?php
// This file is part of Moodle Course Rollover Plugin
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package     local_schoolinfo
 * @author      iProgrammer
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_schoolinfo\form\edit;
use local_schoolinfo\manager;

require_once __DIR__ . '/../../config.php';

require_login();
$context = context_system::instance();
require_capability( 'local/schoolinfo:manageschoolinfos', $context );

$PAGE->set_url( new moodle_url( '/local/schoolinfo/edit.php' ) );
$PAGE->set_context( \context_system::instance() );
$PAGE->set_title( 'Edit' );

$schoolinfoid = optional_param( 'schoolinfoid', null, PARAM_INT );
if ( $schoolinfoid ) {
	$PAGE->set_heading( get_string( 'edit_schoolinfos', 'local_schoolinfo' ) );
} else {
	$PAGE->set_heading( get_string( 'add_schoolinfos', 'local_schoolinfo' ) );
}


// We want to display our form.
$mform = new edit();
global $DB;
if ( $mform->is_cancelled() ) {
	// Go back to view.php page
	redirect( $CFG->wwwroot . '/local/schoolinfo/view.php', get_string( 'cancelled_form', 'local_schoolinfo' ) );

} elseif ( $fromform = $mform->get_data() ) {

	$manager = new manager();

	if ( $fromform->id ) {
		// We are updating an existing schoolinfo.
		$manager->update_schoolinfo( $fromform->id, $fromform->schoolname, $fromform->schoolboard, $fromform->schooldistrict, $fromform->schooludise, $fromform->schoolpincode );
		redirect( $CFG->wwwroot . '/local/schoolinfo/view.php', get_string( 'updated_form', 'local_schoolinfo' ) . $fromform->schoolname );
	}
	/*
	// Return true if the count is greater than 0, false otherwise.
	if ( $DB->record_exists_select( 'local_schoolinfo', 'schooludise = ?', array( $fromform->schooludise ) ) ) {
		// return true;
		\core\notification::add("UDISE Code already exsit", \core\output\notification::NOTIFY_ERROR);
	}else{
		$manager->create_schoolinfo($fromform->schoolname, $fromform->schooludise, $fromform->schoolpincode);
		// Go back to view.php page
		redirect($CFG->wwwroot . '/local/schoolinfo/view.php', get_string('created_form', 'local_schoolinfo') . $fromform->schoolname);
	}
	*/

	$manager->create_schoolinfo( $fromform->schoolname, $fromform->schoolboard, $fromform->schooldistrict, $fromform->schooludise, $fromform->schoolpincode );
	// Go back to view.php page
	redirect( $CFG->wwwroot . '/local/schoolinfo/view.php', get_string( 'created_form', 'local_schoolinfo' ) . $fromform->schoolname );


}

if ( $schoolinfoid ) {
	// Add extra data to the form.
	global $DB;
	$manager    = new manager();
	$schoolinfo = $manager->get_schoolinfo( $schoolinfoid );
	if ( ! $schoolinfo ) {
		throw new invalid_parameter_exception( 'Message not found' );
	}
	$mform->set_data( $schoolinfo );
}

echo $OUTPUT->header();
$mform->display();
echo $OUTPUT->footer();
