<?php
// This file is part of Moodle Course Rollover Plugin
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.


/**
 * @package     local_schoolinfo
 * @author      Hariom
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_schoolinfo\form;

use moodleform;

require_once "$CFG->libdir/formslib.php";

class edit extends moodleform {
	// Add elements to form
	public function definition() {
		global $CFG;
		$mform = $this->_form; // Don't forget the underscore!

		$mform->addElement( 'hidden', 'id' );
		$mform->setType( 'id', PARAM_INT );

		$mform->addElement( 'text', 'schoolname', get_string( 'school_name', 'local_schoolinfo' ) ); // Add elements to your form
		$mform->setType( 'schoolname', PARAM_NOTAGS );                   // Set type of element
		$mform->addRule( 'schoolname', null, 'required', null, 'client' );

		$mform->addElement( 'text', 'schoolboard', get_string( 'school_board', 'local_schoolinfo' ) ); // Add elements to your form
		$mform->setType( 'schoolboard', PARAM_NOTAGS );                   // Set type of element
		$mform->addRule( 'schoolboard', null, 'required', null, 'client' );

		$mform->addElement( 'text', 'schooldistrict', get_string( 'school_district', 'local_schoolinfo' ) ); // Add elements to your form
		$mform->setType( 'schooldistrict', PARAM_NOTAGS );                   // Set type of element
		$mform->addRule( 'schooldistrict', null, 'required', null, 'client' );

		$mform->addElement( 'text', 'schoolpincode', get_string( 'school_pincode', 'local_schoolinfo' ) ); // Add elements to your form
		$mform->setType( 'schoolpincode', PARAM_NOTAGS );                   // Set type of element
		$mform->addRule( 'schoolpincode', null, 'required', null, 'client' );
		$mform->addRule( 'schoolpincode', get_string( 'minimumlength', 'local_schoolinfo', 6 ), 'minlength', 6, 'client' );
		$mform->addRule( 'schoolpincode', get_string( 'maximumchars', '', 6 ), 'maxlength', 6, 'client' );
		$mform->addRule( 'schoolpincode', null, 'numeric', null, 'client' );
		$mform->addRule( 'schoolpincode', null, 'numeric', null, 'server' );

		$mform->addElement( 'text', 'schooludise', get_string( 'school_udise', 'local_schoolinfo' ) ); // Add elements to your form
		$mform->setType( 'schooludise', PARAM_NOTAGS );                   // Set type of element
		$mform->addRule( 'schooludise', null, 'required', null, 'client' );
		// $mform->addRule( 'schooludise', get_string( 'minimumlength', 'local_schoolinfo', 11 ), 'minlength', 11, 'client' );
		// $mform->addRule( 'schooludise', get_string( 'maximumchars', '', 11 ), 'maxlength', 11, 'client' );
		$mform->addRule( 'schooludise', null, 'numeric', null, 'client' );
		$mform->addRule( 'schooludise', null, 'numeric', null, 'server' );

		$this->add_action_buttons();
	}
	// Custom validation should be added here.
	/*
	public function validation( $data, $files ) {
		global $DB;
		$errors = array();

		// Check course doesn't already exist.
		if ( ! empty( $data['schooludise'] ) ) {
			// Check schooludise.
			if ( $DB->record_exists_select( 'local_schoolinfo', 'schooludise = ?', array( $data['schooludise'] ) ) ) {
				$errors['schooludise'] = get_string( 'udiseexists', 'local_schoolinfo' );
			}
		}

		return $errors;
	}

	*/
}
