<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Lists the course categories
 *
 * @copyright 1999 Martin Dougiamas  http://dougiamas.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @package course
 */

require_once("../config.php");
require_once($CFG->dirroot. '/course/lib.php');

$categoryid = optional_param('categoryid', 0, PARAM_INT); // Category id
$redirectid = optional_param( 'redirect', 0, PARAM_INT ); // redirectid id
$site = get_site();

if ($CFG->forcelogin) {
    require_login();
}

//$heading = $site->fullname;
$heading = '{mlang en}Boards{mlang}{mlang hi} बोर्डों {mlang}';
if ($categoryid) {
    $category = core_course_category::get($categoryid); // This will validate access.
    $PAGE->set_category_by_id($categoryid);
    $PAGE->set_url(new moodle_url('/course/index.php', array('categoryid' => $categoryid)));
    $PAGE->set_pagetype('course-index-category');
    $heading = $category->get_formatted_name();

    if ( $category->depth == 1 ) {
		$heading = '{mlang en}Medium{mlang}{mlang hi}माध्यम{mlang}';
	} elseif ( $category->depth == 2 ) {
		$heading = '{mlang en}Standards{mlang}{mlang hi}कक्षा{mlang}';
	}elseif ( $category->depth == 3 ) {
		$heading = '{mlang en}Courses{mlang}{mlang hi}पाठ्यक्रम{mlang}';
    }
} else if ($category = core_course_category::user_top()) {
    // Check if there is only one top-level category, if so use that.
    $categoryid = $category->id;
    $PAGE->set_url('/course/index.php');
    if ($category->is_uservisible() && $categoryid) {
        $PAGE->set_category_by_id($categoryid);
        $PAGE->set_context($category->get_context());
        if (!core_course_category::is_simple_site()) {
            $PAGE->set_url(new moodle_url('/course/index.php', array('categoryid' => $categoryid)));
            $heading = $category->get_formatted_name();
        }
    } else {
        $PAGE->set_context(context_system::instance());
    }
    $PAGE->set_pagetype('course-index-category');
} else {
    throw new moodle_exception('cannotviewcategory');
}
/*
// Custom logic for redirect user to all course page. Based on BMS selected.
if (0 == $categoryid ) {
	if (! $redirectid ) {
	global $DB, $USER;
	// Step 1: Get user profile field values.
	$getUserRoleSelection = $USER->profile['RoleSelection']; // Example: Student,Teacher,Parent.
	$getUserBoard         = $USER->profile['board']; // Example: Haryana, Bihar
	$getUserMedium        = $USER->profile['medium'];      // Example: Hinglish, Hindi, English
	$getUserStandard      = $USER->profile['standard'];    // Example: STD 9, STD 10, STD 11
	if ( 'Student' == $getUserRoleSelection ) {
		// Step 2: Get the Board category (the top level category).
		$boardCategory = $DB->get_record(
			'course_categories',
			array(
				'name'   => $getUserBoard,
				'parent' => 0,
			)
		);
		if ( $boardCategory ) {
			// Step 3: Get the Medium category under the Board category.
			$mediumCategory = $DB->get_record(
				'course_categories',
				array(
					'name'   => $getUserMedium,
					'parent' => $boardCategory->id,
				)
			);
			if ( $mediumCategory ) {
					// Step 4: Get the Standard category under the Medium category.
					$standardCategory = $DB->get_record(
						'course_categories',
						array(
							'name'   => $getUserStandard,
							'parent' => $mediumCategory->id,
						)
					);
				if ( $standardCategory ) {
						// Step 5: You have found the final category (Standard) based on the hierarchy.
						redirect( new moodle_url( '/course/index.php', array( 'categoryid' => $standardCategory->id ) ) );
				} else {
					redirect( new moodle_url( '/course/index.php', array( 'categoryid' => $mediumCategory->id ) ) );
				}
			} else {
				redirect( new moodle_url( '/course/index.php', array( 'categoryid' => $boardCategory->id ) ) );
			}
		}
	}
	}
}
*/

$PAGE->set_pagelayout('coursecategory');
$PAGE->set_primary_active_tab('home');
$PAGE->add_body_class('limitedwidth');
$courserenderer = $PAGE->get_renderer('core', 'course');

$PAGE->set_heading($heading);
$content = $courserenderer->course_category($categoryid);

$PAGE->set_secondary_active_tab('categorymain');

echo $OUTPUT->header();
echo $OUTPUT->skip_link_target();
echo $content;

// Trigger event, course category viewed.
$eventparams = array('context' => $PAGE->context, 'objectid' => $categoryid);
$event = \core\event\course_category_viewed::create($eventparams);
$event->trigger();

echo $OUTPUT->footer();
