<?php
global $CFG;
require_once($CFG->dirroot . '/theme/edash/inc/block_handler/get-content.php');
class block_jeet_5c_cards extends block_base {
    public function init() {
        $this->title = get_string('pluginname', 'block_jeet_5c_cards');
    }

    // Declare second
    public function specialization()
    {
        global $CFG, $DB;
        include($CFG->dirroot . '/theme/edash/inc/block_handler/specialization.php');
        if (empty($this->config)) {
            $this->config = new \stdClass();

            $this->config->cards_title1          = 'Meal Planning';
            $this->config->cards_content1        = 'Card Discription';
            $this->config->cards_title2          = 'Reducing Food Waste';
            $this->config->cards_content2        = 'Card Discription';
            $this->config->cards_title3          = 'Knife Skills';
            $this->config->cards_content3        = 'Card Discription';
            $this->config->cards_title4          = 'Party Food';
            $this->config->cards_content4        = 'Card Discription';
        }
    }

    public function get_content() {
        global $CFG, $DB;

        $this->content         =  new stdClass;

        $cardsnumber = 5;
        if(isset($this->config->cards_number)){
            $cardsnumber = $this->config->cards_number;
        }

        // Title
        if(isset($this->config->title)) { $cardtitle = $this->config->title; }else{ $cardtitle = ''; }
         // Top Discription
        if(isset($this->config->topdiscription)) { $topdiscription = $this->config->topdiscription; }else{ $topdiscription = ''; }
         // Bottom Discription
        if(isset($this->config->bottomdiscription)) { $bottomdiscription = $this->config->bottomdiscription; }else{ $bottomdiscription = ''; }

        $text = '';
            $text .= '
            <div class="imagecards-wrap-area py-4">
                <div class="container-fluid">
                    <div class="section-title style-two mb-2 text-center">
                        <h3>'.format_text($cardtitle, FORMAT_HTML, array('filter' => true)).'</h3>
                        </div>
                        <p class="text-center">'.format_text($topdiscription, FORMAT_HTML, array('filter' => true)).'</p>
                    <div class="row justify-content-center">';
                        for($i = 1; $i <= $cardsnumber; $i++) {
                            $img = 'img' . $i;
                            $cards_title = 'cards_title' . $i;
                            $cards_subtitle = 'cards_subtitle' . $i;
                            $cards_content = 'cards_content' . $i;

                            // Image
                            if(isset($this->config->$img)) { $img = $this->config->$img; }else{ $img = ''; }

                            // Title
                            if(isset($this->config->$cards_title)) { $cards_title = $this->config->$cards_title; }else{ $cards_title = ''; }

                            // Subtitle
                            if(isset($this->config->$cards_subtitle)) { $cards_subtitle = $this->config->$cards_subtitle; }else{ $cards_subtitle = ''; }

                            // Content
                            if(isset($this->config->$cards_content)) { $cards_content = $this->config->$cards_content; }else{ $cards_content = ''; }
                            $text .= '
                                <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2">
                                    <div class="wrap-card text-center mb-3">';
                                        if($img):
                                            $img = $img;
                                            $text .= '
                                            <img src="'.edash_block_image_process($img).'" alt="'.format_text($cards_title, FORMAT_HTML, array('filter' => true)).'">';
                                        endif;
                                        $text .= '
                                        <h4 class="pt-3">'.format_text($cards_title, FORMAT_HTML, array('filter' => true)).'</h4>
                                        <h6>'.format_text($cards_subtitle, FORMAT_HTML, array('filter' => true)).'</h6>
                                        <p>'.format_text($cards_content, FORMAT_HTML, array('filter' => true)).'</p>
                                    </div>
                                </div>';
                        } $text .= '
                    </div>
                    <p class="text-center">'.format_text($bottomdiscription, FORMAT_HTML, array('filter' => true)).'</p>
                </div>
            </div>';
        $this->content->footer = '';
        $this->content->text   = $text;

        return $this->content;
    }

    /**
     * The block can be used repeatedly in a page.
     */
    function instance_allow_multiple() {
        return true;
    }

    /**
     * Enables global configuration of the block in settings.php.
     *
     * @return bool True if the global configuration is enabled.
     */
    function has_config() {
        return false;
    }

    /**
     * Sets the applicable formats for the block.
     *
     * @return string[] Array of pages and permissions.
     */
    function applicable_formats() {
        return array(
            'all' => true,
            'my' => false,
            'admin' => false,
            'course-view' => true,
            'course' => true,
        );
    }

}
