<?php

// custom api for validate moodle users

define('AJAX_SCRIPT', true);
define('REQUIRE_CORRECT_ACCESS', true);
define('NO_MOODLE_COOKIES', true);

require_once(__DIR__ . '/config.php');

// Allow CORS requests.
header('Access-Control-Allow-Origin: *');

require_once($CFG->dirroot.'/user/lib.php');

$username = required_param('username', PARAM_RAW);
$password = required_param('password', PARAM_RAW);

$username = trim(core_text::strtolower($username));
if ($user = authenticate_user_login($username, $password)) {
    if ($user->suspended || $user->deleted) {
        echo json_encode(array('error' => 'true','message' => 'Account suspended or deleted'));
    } else {
        // complete_user_login($user);
        echo json_encode(array('error' => 'false','message' => 'Authentication is valid'));
    }
} else {
    echo json_encode(array('error' => 'true','message' => 'Invalid login, please try again'));
}